
;	7z.asm

ALINK	equ	-1

HELP_ORIGINAL	equ	0

CLINE_BUF_SIZE	equ	200h
OUT_BUF_SIZE	equ	8000h
BUF_SIZE	equ	1000h


extern	LoadLibraryA
extern	FreeLibrary
extern	GetProcAddress
extern	GetCommandLineA
extern	WriteFile

%if	ALINK = -1
import	LoadLibraryA	KERNEL32.DLL
import	FreeLibrary	KERNEL32.DLL
import	GetProcAddress	KERNEL32.DLL
import	GetCommandLineA	KERNEL32.DLL
import	WriteFile	KERNEL32.DLL
%endif

STDOUT_HANDLE	equ	-11	;(dword)

section .text use32 class=code
..start
	call	init_dll
	call	display_dll_ver
%if	ALINK = -1
	call	[GetCommandLineA]
%else
	call	GetCommandLineA
%endif
	call	skip_com_name
	mov	[params_address],eax
	cmp	byte [eax],0
	je	?m_help
	cmp	dword [dll_handle],0
	je	?m_exit_2
	call	exec_7zip
	mov	eax,[result_code]
?m_exit:
	call	flush_buf
	ret
?m_help:
	mov	eax,string_help
	call	display_string
	mov	eax,0
	jmp	?m_exit
?m_exit_2:
	mov	eax,-1
	jmp	?m_exit


free_dll:
	push	dword [dll_handle]
%if	ALINK = -1
	call	[FreeLibrary]
%else
	call	FreeLibrary
%endif
	ret


init_dll:
	push	dword string_7zip32_dll
%if	ALINK = -1
	call	[LoadLibraryA]
%else
	call	LoadLibraryA
%endif
	mov	[dll_handle],eax
	or	eax,eax
	je	?i_d_1

	push	dword string_SevenZipGetVersion
	push	dword [dll_handle]
%if	ALINK = -1
	call	[GetProcAddress]
%else
	call	GetProcAddress
%endif
	mov	[SevenZipGetVersion],eax
	push	dword string_SevenZip
	push	dword [dll_handle]
%if	ALINK = -1
	call	[GetProcAddress]
%else
	call	GetProcAddress
%endif
	mov	[SevenZip],eax

?i_d_1:
	ret


display_dll_ver:
	mov	eax,string_dll_ver_is
	call	display_string
	cmp	dword [dll_handle],0
	je	?d_d_v_no

	call	get_dll_ver
	call	display_dec16
	mov	eax,string_dll_ver_is_end
	call	display_string
	call	display_cr_lf
	ret
?d_d_v_no:
	mov	eax,string_not_exist
	call	display_string
	mov	eax,string_dll_ver_is_end
	call	display_string
	call	display_cr_lf
	ret


display_result_code:
;	in eax = result code
	push	eax
	mov	eax,string_result_is
	call	display_string
	pop	eax
	call	display_hex32
	mov	eax,string_result_is_end
	call	display_string
	call	display_cr_lf
	ret


add_no_dialog_switch:
	mov	eax,cline_buf
	mov	edx,[params_address]
	call	cat_string
	mov	dword [params_address],cline_buf
	ret


exec_7zip:
	call	add_no_dialog_switch
	call	call_7zip
	mov	[result_code],eax
	call	display_result_code
	mov	byte [out_buf+OUT_BUF_SIZE],0
	mov	eax,out_buf
;;	call	display_string_ex
	call	display_string
	call	free_dll
	ret


get_dll_ver:
	call	[SevenZipGetVersion]
	ret


call_7zip:
	push	dword OUT_BUF_SIZE
	push	dword out_buf
	push	dword [params_address]
	push	dword 0	;NULL
	call	[SevenZip]
	ret


;------------------------------------------------------------------------------
skip_com_name:
;	in eax = address
;	out eax = address
	mov	esi,eax
	lodsb
	cmp	al,'"'
	je	?s_c_n_4
?s_c_n_1:
	lodsb
	or	al,al
	je	?s_c_n_3
	cmp	al,' '
	je	?s_c_n_2
	cmp	al,9	;TAB
	je	?s_c_n_2
	jmp	?s_c_n_1
?s_c_n_2:
	lodsb
	or	al,al
	je	?s_c_n_3
	cmp	al,' '
	je	?s_c_n_2
	cmp	al,9	;TAB
	je	?s_c_n_2
?s_c_n_3:
	dec	esi
	mov	eax,esi
	ret
?s_c_n_4:
	lodsb
	cmp	al,'"'
	jne	?s_c_n_4
	jmp	?s_c_n_1


;------------------------------ \v~eBu2 -----------------------------
display_cr_lf:
;	in : nothing
	mov	al,0dh
	call	display_char
	mov	al,0ah
	call	display_char
	ret


;------------------------------ v~eBu ----------------------------
cat_string:
;	in eax = dest string address
;	   edx = source string address
	mov	edi,eax
	mov	ecx,8000h
	xor	al,al
	cld
	repne	scasb
	dec	edi
	mov	ebx,edi
	mov	edi,edx
	mov	ecx,8000h
	xor	al,al
	repne	scasb
	inc	ecx
	mov	eax,8000h
	sub	eax,ecx
	mov	ecx,eax
	mov	esi,edx
	mov	edi,ebx
	rep	movsb
	ret


;-------------------------------- \v~eBu ----------------------------
display_dec16:
;	in ax = value
	movzx	eax,ax
	xor	edx,edx
	mov	ebx,10000
	call	_display_qd4
	ret


_display_qd4:
;	in edx:eax = number to be divided
;	   ebx = dividing number
	or	ebx,ebx
	je	?_d_qd4_1
	div	ebx
	add	al,'0'
	push	edx
	push	ebx
	call	display_char
	pop	ebx
	mov	eax,ebx
	xor	edx,edx
	mov	ebx,10
	div	ebx
	mov	ebx,eax
	pop	eax
	xor	edx,edx
	call	_display_qd4
?_d_qd4_1:
	ret


;------------------------------------------------------------------------------
display_hex32:
;	in eax = value
	push	eax
	mov	cl,16
	shr	eax,cl
	call	display_hex16
	pop	eax
	call	display_hex16
	ret


display_hex16:
;	in ax = value
	push	eax
	mov	al,ah
	call	display_hex8
	pop	eax
	call	display_hex8
	ret


display_hex8:
;	in al = value
	push	eax
	mov	cl,4
	shr	al,cl
	call	display_hex4
	pop	eax
	call	display_hex4
	ret


display_hex4:
;	in al-b3~b0 = value
	and	al,0fh
	add	al,'0'
	cmp	al,'9'
	jbe	?d_h4_1
	add	al,'A'-('9'+1)
?d_h4_1:
	call	display_char
	ret


flush_buf:
	cmp	dword [buf_ptr],buf
	je	?f_b_end
	push	dword 0
	push	dword result_length
	mov	eax,[buf_ptr]
	sub	eax,buf
	push	eax
	push	dword buf
	push	dword STDOUT_HANDLE
%if	ALINK = -1
	call	[WriteFile]
%else
	call	WriteFile
%endif
	mov	dword [buf_ptr],buf
?f_b_end:
	ret


display_char:
;	in al = char
	mov	ecx,[buf_ptr]
	mov	[ecx],al
	inc	dword [buf_ptr]
	cmp	dword [buf_ptr],buf+BUF_SIZE
	je	?d_c_1
	cmp	al,' '
	jae	?d_c_2
?d_c_1:
	call	flush_buf
	ret
?d_c_2:
	ret


display_string:
;	in eax = address
	mov	esi,eax
?d_a_1:
	lodsb
	or	al,al
	je	?d_a_2
	push	esi
	call	display_char
	pop	esi
	jmp	?d_a_1
?d_a_2:
	ret


;	SevenZip̏óAs0aĥ݂ɂȂĂB
;	ʂɕ\镪ɂ͖ȂAmoreg肷ƕ\B
;	SevenZip̕f[^C̕łA
;	printf()ŏo͂AeLXg[hŃI[vt@Cɏނ
;	0dh,0ahɕϊ邩łB
;	ȉ́AsSȉsR[h0dh,0ahɓWJ镶o̓[`łB
;	KvȂ̂A0dĥ݂ꍇ0dh,0ahɕϊ(^^;)
display_string_ex:
;	in eax = address
	mov	esi,eax
	mov	dword [cr_occurred],0
?d_a_ex_1:
	lodsb
	or	al,al
	je	?d_a_ex_zero

	cmp	al,0dh
	je	?d_a_ex_cr

	cmp	al,0ah
	je	near ?d_a_ex_lf

?d_a_ex_normal:
	cmp	dword [cr_occurred],0
	jne	?d_a_ex_normal_preCr

	push	esi
	call	display_char
	pop	esi
	jmp	?d_a_ex_1
?d_a_ex_normal_preCr:
	push	eax
	mov	al,0ah
	push	esi
	call	display_char
	pop	esi
	pop	eax
	push	esi
	call	display_char
	pop	esi
	mov	dword [cr_occurred],0
	jmp	?d_a_ex_1


?d_a_ex_zero:
	cmp	dword [cr_occurred],0
	jne	?d_a_ex_zero_preCr

	ret
?d_a_ex_zero_preCr:
	mov	al,0ah
	push	esi
	call	display_char
	pop	esi
	jmp	?d_a_ex_1


?d_a_ex_cr:
	cmp	dword [cr_occurred],0
	jne	?d_a_ex_cr_preCr

	push	esi
	call	display_char
	pop	esi
	mov	dword [cr_occurred],-1
	jmp	?d_a_ex_1
?d_a_ex_cr_preCr:
	push	eax
	mov	al,0ah
	push	esi
	call	display_char
	pop	esi
	pop	eax
	push	esi
	call	display_char
	pop	esi
	mov	dword [cr_occurred],-1
	jmp	?d_a_ex_1


?d_a_ex_lf:
	cmp	dword [cr_occurred],0
	jne	?d_a_ex_lf_preCr

	push	eax
	mov	al,0dh
	push	esi
	call	display_char
	pop	esi
	pop	eax
	push	esi
	call	display_char
	pop	esi
	mov	dword [cr_occurred],0
	jmp	?d_a_ex_1
?d_a_ex_lf_preCr:
	push	esi
	call	display_char
	pop	esi
	mov	dword [cr_occurred],0
	jmp	?d_a_ex_1


;------------------------------------------------------------------------------
section .data use32 class=data
result_code	dd	0
params_address	dd	0
dll_handle	dd	0
SevenZip	dd	0
SevenZipGetVersion	dd	0

cr_occurred	dd	0

buf_8	db	0,0,0,0
result_length	dd	0

string_7zip32_dll	db	'7-ZIP32.DLL',0
string_SevenZip	db	'SevenZip',0
string_SevenZipGetVersion	db	'SevenZipGetVersion',0
string_not_exist	db	'Not Exist',0


string_dll_ver_is	db	'7Z.EXE 0.02 [7-ZIP32.DLL ',0
string_dll_ver_is_end	db	']',0
string_result_is	db	'[Result 0x',0
string_result_is_end	db	']',0
string_help	resb	0
 db "(7-zip32.dll ver 3.13.00.04̐)( Hc )",0dh,0ah
 db "1. R}hC̗l",0dh,0ah
 db "=======================",0dh,0ah
 db "",0dh,0ah
 db "  <command> [<switch>...] <archive_name> [<base_dir>\] [<arguments>...]",0dh,0ah
 db "",0dh,0ah
 db "    command      : R}hB",0dh,0ah
 db "    switch       : XCb`B(<'/' | '-'><switch_characters>[<option>])",0dh,0ah
 db "    archive_name : {ƂȂ鏑ɖB",0dh,0ah
 db "    base_dir     : fBNgB\ ŏIKv܂B",0dh,0ah
 db "    arguments    : switchAwildcardAfilenameAlist_fileB",0dh,0ah
 db "",0dh,0ah
 db "    wildcard     : ChJ[hB",0dh,0ah
 db "    filename     : t@CB",0dh,0ah
 db "    list_file    : t@C̃Xgt@CB(@{filename})",0dh,0ah
 db "",0dh,0ah
 db "    [ ] ͏ȗ\B",0dh,0ah
 db "    ... ͕w\B",0dh,0ah
 db "",0dh,0ah
 db "    command ͍ŏɋLqKvL܂B",0dh,0ah
 db "    archive_name  command ̌ɗŏ̃t@CɂȂ܂B",0dh,0ah
 db "    XCb`yуt@C͔Cӂ̏Ԃō\܂B",0dh,0ah
 db "",0dh,0ah
 db '    Xy[X܂ރt@C͈ȉ̗l""őŜ͂ĂB',0dh,0ah
 db '    ) "Dir\Program files\*"',0dh,0ah
 db "     7-ZipŃT|[gĂȉ̌` 7-zip32.dll ł",0dh,0ah
 db "       T|[g܂B",0dh,0ah
 db '    ) Dir\"Program files"\*',0dh,0ah
 db "",0dh,0ah
 db "    XCb`IvV̓R}hC̒ߖ񂷂ׂɑgݍ킹",0dh,0ah
 db "    o܂BA̃IvV͕̂",0dh,0ah
 db "    ꂽ̃g[N̍ŌオIvVɂȂ܂B",0dh,0ah
 db "    R 7-zip32.dll IvV̈ƂĈg[N̎c",0dh,0ah
 db "    FĂ܂łB",0dh,0ah
 db "",0dh,0ah
 db "    7-zip32.dll Ŏgp郏ChJ[hI Windows95 ƎĂ܂B",0dh,0ah
 db "    E'*' ͔Cӂ̘̕AӖ܂B",0dh,0ah
 db "    E'?' ͔Cӂ̕Ӗ܂B",0dh,0ah
 db "",0dh,0ah
 db "    7-zip32.dll  VXeChJ[h}XN͂Ă炸A",0dh,0ah
 db "    *.* SẴt@CӖƌÂKɏ]܂B",0dh,0ah
 db "    7-zip32.dll  *.* SĂ̊gqt@CƂĈ܂B",0dh,0ah
 db "    SẴt@Cɂ * gpȂ΂Ȃ܂",0dh,0ah
 db "",0dh,0ah
 db "    )",0dh,0ah
 db "@@\\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db '    *.txt gq ".txt" ̑SẴt@CӖ܂B    ',0dh,0ah
 db "    \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "    ?a* @PԖڂ̕ 'a' ̑SẴt@CӖ܂B ",0dh,0ah
 db "    \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "    *1* @'1' ܂ޑSẴt@CӖ܂B            ",0dh,0ah
 db "    \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "    *.*.* '.' QSẴt@CӖ܂B        ",0dh,0ah
 db "    \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "",0dh,0ah
 db "    R}hCŃt@CƃChJ[hSgpȂ",0dh,0ah
 db '    ꍇ́AftHg̃ChJ[h "*" gp܂B',0dh,0ah
 db "    ",0dh,0ah
 db "    t@Cɉۂ̃ChJ[hƃt@C̐B",0dh,0ah
 db "    EChJ[hƃt@C̓fBXNႵ̓lbg[N",0dh,0ah
 db "      ܂ގo܂BSẴt@CƃJ[hƃt@C",0dh,0ah
 db "      fBXÑJgfBNg̃pXyяɓ",0dh,0ah
 db "      [gfBNg̃pXƂ݂Ȃ܂B",0dh,0ah
 db "      pX̍ŏ̕iŏ '\' L̑O̕j͏ɖO",0dh,0ah
 db "      ChJ[hłȂ΂Ȃ܂B",0dh,0ah
 db "    EChJ[hƃt@C '\' LŏI鎖o܂B",0dh,0ah
 db "    EChJ[h̓pX̍Ō̕ɂ̂݃ChJ[h",0dh,0ah
 db "      i'*'  '?'j܂ގo܂B",0dh,0ah
 db "@@\\\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "    Dir1\*.cpp          肠܂B                      ",0dh,0ah
 db "    \\\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "    c:\Dir1\*.cpp     @sFpX̓fBXN܂ł܂B",0dh,0ah
 db "    \\\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "    Dir1\Dir2\g?.txt @ 肠܂B                      ",0dh,0ah
 db "    \\\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "    Dir1\D?r2\file1.txt sFŌ̕ȊOŃChJ[h  b",0dh,0ah
 db "                              LgpĂ܂B        ",0dh,0ah
 db "    \\\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "",0dh,0ah
 db "  Xgt@C",0dh,0ah
 db "",0dh,0ah
 db "    ʂȃXgt@Cit@C̃Xg܂łt@Cj",0dh,0ah
 db "    Pȏ̃t@CChJ[hw肷邱Ƃł܂B",0dh,0ah
 db "    Xgt@C̃t@ĆAXy[XA^uAsŋ؂Ȃ",0dh,0ah
 db "    Ȃ܂B",0dh,0ah
 db '    Xy[X܂ރChJ[hyуt@C "" ň͂łB',0dh,0ah
 db "",0dh,0ah
 db "    ̃Xgt@CT|[g܂B",0dh,0ah
 db "",0dh,0ah
 db '    Ⴆ "list.txt" ̓eȉ̒ʂȂA',0dh,0ah
 db "",0dh,0ah
 db '      "My programs\*.cpp"',0dh,0ah
 db "      Src\*.cpp",0dh,0ah
 db "",0dh,0ah
 db "    ̃R}h",0dh,0ah
 db "",0dh,0ah
 db "      a -tzip archive.zip @listfile.txt",0dh,0ah
 db "",0dh,0ah
 db '    archive.zip  "My programs" "src" ̑SĂ "*.cpp" t@C',0dh,0ah
 db "    ǉ܂B",0dh,0ah
 db "",0dh,0ah
 db "",0dh,0ah
 db "2. ߂̏ڍ",0dh,0ah
 db "=============",0dh,0ah
 db "",0dh,0ah
 db "  a : ǉ",0dh,0ah
 db "  PPPP",0dh,0ah
 db "  @@ɂɃt@Cǉ܂B",0dh,0ah
 db "      7z ɂɒǉꍇ -ms=off XCb`tĉB",0dh,0ah
 db "      \bhɂɃt@Cǉ鎖͏o܂B",0dh,0ah
 db "",0dh,0ah
 db "    : a -tzip archive.zip subdir\*",0dh,0ah
 db "      ",0dh,0ah
 db "      fBNg subdir ̑SẴt@C",0dh,0ah
 db "      archive.zip ɒǉ܂B",0dh,0ah
 db "",0dh,0ah
 db "    : a -t7z archive.7z subdir\* -ms=off",0dh,0ah
 db "",0dh,0ah
 db "      fBNg subdir ̑SẴt@C",0dh,0ah
 db "      archive.7z ɒǉ܂B",0dh,0ah
 db "",0dh,0ah
 db "    ̃R}hƋɎgpłXCb`B",0dh,0ah
 db "",0dh,0ah
 db "      -hide, -i, -m, -r, -t, -u, -w, -x, -p",0dh,0ah
 db "",0dh,0ah
 db "    Q",0dh,0ah
 db "",0dh,0ah
 db "      R}h: d, u",0dh,0ah
 db "      XCb`: -u",0dh,0ah
 db "",0dh,0ah
 db "  d : 폜",0dh,0ah
 db "  PPPP",0dh,0ah
 db "      ɂt@C폜܂B",0dh,0ah
 db "      7z ɂ폜ꍇ -ms=off XCb`tĉB",0dh,0ah
 db "      \bhɂt@C폜鎖͏o܂B",0dh,0ah
 db "",0dh,0ah
 db "    : d archive.zip *.bak",0dh,0ah
 db "",0dh,0ah
 db "      archive.zip SĂ *.bak t@C폜܂B",0dh,0ah
 db "",0dh,0ah
 db "    : d archive.7z *.txt -ms=off",0dh,0ah
 db "",0dh,0ah
 db "      archive.7z SĂ *.txt t@C폜܂B",0dh,0ah
 db "",0dh,0ah
 db "    ̃R}hƋɎgpłXCb`B",0dh,0ah
 db "",0dh,0ah
 db "      -hide, -i, -m, -r, -t, -u, -w, -x, -p",0dh,0ah
 db "",0dh,0ah
 db "    Q",0dh,0ah
 db "",0dh,0ah
 db "      R}h: a, u",0dh,0ah
 db "      XCb`: -u",0dh,0ah
 db "",0dh,0ah
 db "  e : ",0dh,0ah
 db "  PPPP",0dh,0ah
 db "      ɂt@CJgfBNgA",0dh,0ah
 db "      ͎w̃fBNgɉ𓀂܂B",0dh,0ah
 db "      fBNgtŉ𓀂ꍇ x R}hgp܂B",0dh,0ah
 db "",0dh,0ah
 db "    : e archive.zip",0dh,0ah
 db "",0dh,0ah
 db "      archive.zip ̑SẴt@CJgfBNgɉ𓀂܂B",0dh,0ah
 db "",0dh,0ah
 db "    ̃R}hƋɎgpłXCb`B",0dh,0ah
 db "",0dh,0ah
 db "      -ao , -hide, -i, -o, -p, -r, -x, -y, -p",0dh,0ah
 db "",0dh,0ah
 db "    Q",0dh,0ah
 db "",0dh,0ah
 db "      R}h: x",0dh,0ah
 db "",0dh,0ah
 db "  l : Xg",0dh,0ah
 db "  PPPPP",0dh,0ah
 db "      ɂ̓e擾܂B",0dh,0ah
 db "      擾e _szOutput ɏo͂܂B",0dh,0ah
 db "",0dh,0ah
 db "    : l archive.zip",0dh,0ah
 db "",0dh,0ah
 db "      archive.zip ̓e _szOutput ɏo͂܂B",0dh,0ah
 db "",0dh,0ah
 db "    ̃R}hƋɎgpłXCb`B",0dh,0ah
 db "",0dh,0ah
 db "      -i, -r, -x",0dh,0ah
 db "",0dh,0ah
 db "  t : ff",0dh,0ah
 db "  PPPPPPP",0dh,0ah
 db "      ɂ̐ff܂B",0dh,0ah
 db "",0dh,0ah
 db "    : t archive.zip *.doc",0dh,0ah
 db "",0dh,0ah
 db "      archive.zip ̑SĂ *.doc t@C̐ff܂B",0dh,0ah
 db "",0dh,0ah
 db "    ̃R}hƋɎgpłXCb`B",0dh,0ah
 db "",0dh,0ah
 db "      -hide, -i, -r, -p, -x",0dh,0ah
 db "",0dh,0ah
 db "  u : XV",0dh,0ah
 db "  PPPP",0dh,0ah
 db "      ɓ̌Ât@CXVAVt@Cǉ܂B",0dh,0ah
 db "",0dh,0ah
 db "    : u archive.zip *.doc",0dh,0ah
 db "",0dh,0ah
 db "      archive.zip ̑SĂ *.doc t@CXV܂B",0dh,0ah
 db "",0dh,0ah
 db "    ̃R}hƋɎgpłXCb`B",0dh,0ah
 db "",0dh,0ah
 db "      -hide, -i, -m, -r, -t, -u, -w, -x, -p",0dh,0ah
 db "",0dh,0ah
 db "    Q",0dh,0ah
 db "",0dh,0ah
 db "      R}h: a, d",0dh,0ah
 db "      XCb`: -u",0dh,0ah
 db "",0dh,0ah
 db "  x : tpXŉ",0dh,0ah
 db "  PPPPPPPPP",0dh,0ah
 db "      ɂt@CJgfBNgA",0dh,0ah
 db "      ͎w̃fBNgɃfBNgtŉ𓀂܂B",0dh,0ah
 db "",0dh,0ah
 db "    : x archive.zip -oc:\soft *.cpp",0dh,0ah
 db "",0dh,0ah
 db "      archive.zip  *.cpp t@CSĂ",0dh,0ah
 db "      c:\soft fBNgɉ𓀂܂B",0dh,0ah
 db "",0dh,0ah
 db "    ̃R}hƋɎgpłXCb`B",0dh,0ah
 db "",0dh,0ah
 db "      -ao , -hide, -i, -o, -p, -r, -x, -y",0dh,0ah
 db "",0dh,0ah
 db "    Q",0dh,0ah
 db "",0dh,0ah
 db "      R}h: e",0dh,0ah
 db "",0dh,0ah
 db "",0dh,0ah
 db "",0dh,0ah
 db "3. XCb`IvV̏ڍ",0dh,0ah
 db "===========================",0dh,0ah
 db "",0dh,0ah
 db "  -ao : ㏑[h",0dh,0ah
 db "  PPPPPPPPP",0dh,0ah
 db "      𓀎AɃt@C݂̓ݒ肵܂B",0dh,0ah
 db "",0dh,0ah
 db "    \: -ao[a | s | u | t]",0dh,0ah
 db "",0dh,0ah
 db "@@\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "    XCb`                                        ",0dh,0ah
 db "    \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "    -aoa@@SẴt@CmFȂŏ㏑܂B  ",0dh,0ah
 db "    \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "    -aos@@̃t@C̓XLbv܂B            ",0dh,0ah
 db "    \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "    -aou@@𓀂t@CIɃl[܂B  ",0dh,0ah
 db "       @@ Ⴆ name.txt  name_1.txt ɂȂ܂B  ",0dh,0ah
 db "    \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "    -aot@@̃t@CIɃl[܂B    ",0dh,0ah
 db "       @@ Ⴆ name.txt  name_1.txt ɂȂ܂B  ",0dh,0ah
 db "    \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "",0dh,0ah
 db "    : x test.zip -aoa",0dh,0ah
 db "",0dh,0ah
 db "      test.zip SẴt@CJgfBNgɉ𓀂",0dh,0ah
 db "      ̃t@CLꍇ͑Sď㏑ĕۑ܂B",0dh,0ah
 db "",0dh,0ah
 db "    ̃XCb`ƋɎgpłR}hB",0dh,0ah
 db "",0dh,0ah
 db "      e, x",0dh,0ah
 db "",0dh,0ah
 db "    Q",0dh,0ah
 db "",0dh,0ah
 db "      XCb`: -y",0dh,0ah
 db "",0dh,0ah
 db "  -hide : 󋵃_CAO\̗}~",0dh,0ah
 db "  PPPPPPPPPPPPPPPPPP",0dh,0ah
 db "      k𓀎Ȃǂɕ\鏈󋵃_CAO\ɂ܂B",0dh,0ah
 db "",0dh,0ah
 db "    \: -hide",0dh,0ah
 db "",0dh,0ah
 db "      7-Zipɂ̃XCb`͂܂BƎ̎dlłB",0dh,0ah
 db "      \[hłt@C̏㏑̖₢킹",0dh,0ah
 db "      pX[h̖₢킹̎̓_CAO\܂B",0dh,0ah
 db "      }~ɂ -ao, -p, -y, XCb`𕹗p܂B",0dh,0ah
 db "",0dh,0ah
 db "    : x archive.zip -hide -aoa -pabcde *.cpp",0dh,0ah
 db "",0dh,0ah
 db "      archive.zip  *.cpp t@CSĂ",0dh,0ah
 db "      pX[h abcd gp𓀂܂B",0dh,0ah
 db "      ̎A𓀏󋵃_CAO͕\ꂸ",0dh,0ah
 db "      𓀐ɓ̃t@C݂ĂmFŏ㏑܂B",0dh,0ah
 db "",0dh,0ah
 db "    ̃XCb`ƋɎgpłR}hB",0dh,0ah
 db "",0dh,0ah
 db "      a, d, e, t, u, x",0dh,0ah
 db "",0dh,0ah
 db "    Q",0dh,0ah
 db "",0dh,0ah
 db "      XCb`: -ao, -p, -y",0dh,0ah
 db "",0dh,0ah
 db "  -i : ǉt@Cw    󂠂₵",0dh,0ah
 db "  PPPPPPPPPPP",0dh,0ah
 db "      ǉt@CyуChJ[h̕⑫w肵܂B",0dh,0ah
 db "",0dh,0ah
 db "    \: -i[<recurse_type>]<file_ref>",0dh,0ah
 db "",0dh,0ah
 db "            <recurse_type> ::= r[- | 0]",0dh,0ah
 db "            <file_ref>     ::= @{listfile} | !{wildcard}",0dh,0ah
 db "",0dh,0ah
 db "    p[^",0dh,0ah
 db "",0dh,0ah
 db "      <recurse_type>",0dh,0ah
 db "",0dh,0ah
 db "        ̃XCb`ɂĎw肵ChJ[h",0dh,0ah
 db "        t@Cǂ̂悤ɎgȂ΂ȂȂw肵܂B",0dh,0ah
 db "        ̃IvVw肳ĂȂꍇ",0dh,0ah
 db "        -r XCb`Kp܂B",0dh,0ah
 db "        ڍׂ -r XCb`QƂĂB",0dh,0ah
 db "",0dh,0ah
 db "      <file_ref>",0dh,0ah
 db "      ",0dh,0ah
 db "        w肵ChJ[hƃt@C",0dh,0ah
 db "        t@C̃Xgw肵܂B",0dh,0ah
 db "",0dh,0ah
 db "@  @\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "      IvV                                        ",0dh,0ah
 db "      \\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "      {listfile}Xgt@C̖Ow肵܂B          ",0dh,0ah
 db "      \\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "      {wildcard}ChJ[h܂̓t@Cw肵܂B",0dh,0ah
 db "      \\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "",0dh,0ah
 db "    : a -tzip src.zip *.txt -ir!DIR1\*.cpp",0dh,0ah
 db "",0dh,0ah
 db "      JgfBNg̑SĂ *.txt t@C",0dh,0ah
 db "      DIR1 fBNgƂ̃TufBNg",0dh,0ah
 db "      SĂ *.cpp t@C src.zip ɒǉ܂B",0dh,0ah
 db "",0dh,0ah
 db "    ̃XCb`ƋɎgpłR}hB",0dh,0ah
 db "",0dh,0ah
 db "      a, d, e, l, t, u, x",0dh,0ah
 db "",0dh,0ah
 db "    Q",0dh,0ah
 db "",0dh,0ah
 db "      XCb`: -r, -x",0dh,0ah
 db "",0dh,0ah
 db "  -m : k̐ݒ",0dh,0ah
 db "  PPPPPPPPPP",0dh,0ah
 db "      k@̐ݒ܂B",0dh,0ah
 db "",0dh,0ah
 db "    \: -m<method_parameters>",0dh,0ah
 db "",0dh,0ah
 db "        ̃XCb`͏ɂ̌`ɂďς܂B",0dh,0ah
 db "",0dh,0ah
 db "      Zip",0dh,0ah
 db "@  @\\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "      p[^          W                            ",0dh,0ah
 db "      \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "      x=[0 | 5 | 9 ]       5    k̃xݒ肵܂B    ",0dh,0ah
 db "      \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "      m={MethodID}      Deflate ݒ:                   ",0dh,0ah
 db "                                Copy,Deflate,Deflate64,BZip2  ",0dh,0ah
 db "      \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "      fb={NumFastBytes}    32   DeflateGR[_ɗD悷   ",0dh,0ah
 db "                                ̃oCgw肵܂B",0dh,0ah
 db "      \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "      pass={NumPasses}     1    DeflateGR[_           ",0dh,0ah
 db "                                pX̐lݒ肵܂B      ",0dh,0ah
 db "      \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "",0dh,0ah
 db "      x=[0 | 5 | 9 ]",0dh,0ah
 db "",0dh,0ah
 db "        k̃xݒB",0dh,0ah
 db "@  @  \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "        x                                              ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "        0     kB                                          ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "        5     Ẅk@B                                  ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "        9     ōk@B                                    ",0dh,0ah
 db "              ʂȗʂRAMKvƂk͒xȂ܂B   ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "",0dh,0ah
 db "      fb={NumFastBytes}",0dh,0ah
 db "",0dh,0ah
 db "        Deflate GR[_ׂ̈ɗD悷郁̃oCgw肵܂B",0dh,0ah
 db "        oCg 3 - 255 ̊Ԃɐݒ肵ĂB",0dh,0ah
 db "        ftHgl Normal  32 AMaximum  64 ɂȂ܂B",0dh,0ah
 db "        ʏA傫lݒ肷ƈk͎኱Ȃ",0dh,0ah
 db "        kx͒xȂ܂B",0dh,0ah
 db "        AAAf[^ꍇ͈kIɗǂȂ܂B",0dh,0ah
 db "",0dh,0ah
 db "      pass={NumPasses}",0dh,0ah
 db "",0dh,0ah
 db "        Deflate GR[_[ׂ̈̃pX̐lݒ肵܂B",0dh,0ah
 db "        l 1 - 4 ̊ԂŐݒ肵ĂB",0dh,0ah
 db "        ftHgl Normal  1 AMaximum  3 ɂȂ܂B",0dh,0ah
 db "        ʏA傫lݒ肷ƈk͎኱Ȃ",0dh,0ah
 db "        kx͒xȂ܂B",0dh,0ah
 db "        pX傫閈Deflate GR[_[gpʂ",0dh,0ah
 db "        (128 * NumFastBytes)KB ܂B",0dh,0ah
 db "",0dh,0ah
 db "      7z",0dh,0ah
 db "@  @\\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "      p[^    W                                  ",0dh,0ah
 db "      \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "      x=[0|1|5|7|9]  5  k̃xݒ肵܂B            ",0dh,0ah
 db "      \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "      s=[off|on|[e]  on \bh[hݒ肵܂B          ",0dh,0ah
 db "      [{N}f] [{N}b|{                                          ",0dh,0ah
 db "      N}k|{N}m|{N}g]                                          ",0dh,0ah
 db "      \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "      f=[off | on]   on s\t@C̈ktB^ݒB",0dh,0ah
 db "      \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "      hc=[off | on]  on ɂ̃wb_kݒ肵܂B        ",0dh,0ah
 db "      \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "      hcf=[off | on] on ɂ̊Swb_kݒ肵܂B    ",0dh,0ah
 db "      \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "      he=[off | on]  offɂ̃wb_Íݒ肵܂B      ",0dh,0ah
 db "      \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "      b{C1}[s{S1}]:     GR[_̑gݍ킹ݒ肵܂B  ",0dh,0ah
 db "       {C2}[s{S2}]                                            ",0dh,0ah
 db "      \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "      {N}={MethodID}    ݒ肵܂B                    ",0dh,0ah
 db "      [:param1]     LZMALZMA, PPMd, BZip2, Deflate, BCJ, BCJ2,",0dh,0ah
 db "      [:param2][..]     CopyB                                ",0dh,0ah
 db "      \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "      mt=[off | on]  off}`XbfBO[hݒB    ",0dh,0ah
 db "      \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "",0dh,0ah
 db "      x=[0 | 1 | 5 | 7 | 9]",0dh,0ah
 db "",0dh,0ah
 db "        k̃xݒB",0dh,0ah
 db "@  @  \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "        x                                              ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "        0     kB                                          ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "        1     k :  LZMA [hA32KB A        ",0dh,0ah
 db "              HC3 }b`t@C_[ABCJ tB^B            ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "        5     Wk : W LZMA [hA1MB A         ",0dh,0ah
 db "              BT4 }b`t@C_[ANumFastBytes  32A      ",0dh,0ah
 db "              BCJ tB^B                                    ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "        7     ōk : ő LZMA [hA8MB A         ",0dh,0ah
 db "              BT4 }b`t@C_[ANumFastBytes  64A      ",0dh,0ah
 db "              BCJ tB^B                                    ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "        9     k : ő LZMA [hA32MB A        ",0dh,0ah
 db "              BT4b }b`t@C_[ANumFastBytes  64A     ",0dh,0ah
 db "              BCJ2 tB^B                                   ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "",0dh,0ah
 db "      s=[off | on | [e] [{N}f] [{N}b | {N}k | {N}m | {N}g)] ",0dh,0ah
 db "",0dh,0ah
 db "        ɂ\bh[hō쐬܂BftHg s=on łB",0dh,0ah
 db "        \bh[hł̓t@C̓O[v܂B",0dh,0ah
 db "        ʏA\bh[hňkƈk͗ǂȂ܂B",0dh,0ah
 db "@  @  \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "        e         X̐Vt@C̊gqɂ          b",0dh,0ah
 db "                  ʂ̃\bhubNgp܂B          ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "        {N}f      ̃\bhubNɂt@C      ",0dh,0ah
 db "                  Eݒ肵܂B                          ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "        {N}b|{N}k|\bhubNɂŜ̃TCY        ",0dh,0ah
 db "        {N}m|{N}g EoCgݒ肵܂B                      ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "",0dh,0ah
 db "        ftHg̃ubNTCY͐܂B",0dh,0ah
 db "@  @  \\\\\\\\\\\\\\\\",0dh,0ah
 db "        kx\bhubNTCYb",0dh,0ah
 db "        \\\\\\\\\\\\\\\\",0dh,0ah
 db "        k    0 B                   ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\",0dh,0ah
 db "        k  16 MB                 ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\",0dh,0ah
 db "        Wk  256 MB                ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\",0dh,0ah
 db "        ōk  1 GB                  ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\",0dh,0ah
 db "        k  4 GB                  ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\",0dh,0ah
 db "",0dh,0ah
 db "        \bhubNTCY̐͒ʏ툳k܂",0dh,0ah
 db "        ȉ̗_܂B",0dh,0ah
 db "        EɂjꍇAȂȂ܂B",0dh,0ah
 db "        EÃO[vɂ̑SẴt@C܂łȂȂ",0dh,0ah
 db "          t@CQ́it@C͈Ȃ)O[v",0dh,0ah
 db "          𓀎Ԃ𑬂܂B",0dh,0ah
 db "",0dh,0ah
 db "        ݂ 7-Zip ̃o[Wł́A\bhubN̍č\z",0dh,0ah
 db "        KvƂ̂ł΁A\bhɂ̍XVT|[g܂B",0dh,0ah
 db "",0dh,0ah
 db "        F-s=100f10m",0dh,0ah
 db "",0dh,0ah
 db "            ̃\bhubN 100 ̃t@C & 10MB ",0dh,0ah
 db "            \bh[hݒ肵܂B",0dh,0ah
 db "",0dh,0ah
 db "      f=[off | on]",0dh,0ah
 db "",0dh,0ah
 db "        s\t@C̈ktB^ݒFdll, exe, ocx, sfx, sys.",0dh,0ah
 db "        k[h BCJ2 tB^Ƃ̑̃[h BCJ tB^",0dh,0ah
 db "        gp܂B",0dh,0ah
 db "        ftHg f=on łB",0dh,0ah
 db "",0dh,0ah
 db "      hc=[off | on]",0dh,0ah
 db "",0dh,0ah
 db "        ɂ̃wb_k邩Ȃݒ肵܂B",0dh,0ah
 db "        ftHg hc=on łB",0dh,0ah
 db "        wb_kLɂƊ̏Ƀwb_",0dh,0ah
 db "        LZMAɂĈk܂B",0dh,0ah
 db "",0dh,0ah
 db "      hcf=[off | on]",0dh,0ah
 db "",0dh,0ah
 db "        ɂ̊Swb_k邩Ȃݒ肵܂B",0dh,0ah
 db "        ftHg̃[h hcf=on łB",0dh,0ah
 db "        hcf=on ɂ쐬ꂽɂ 7-Zip 2.30 beta 25(2.30.25.01)",0dh,0ah
 db "        ȍ~̃o[Wŉ𓀂鎖o܂B",0dh,0ah
 db "",0dh,0ah
 db "      he=[off | on]",0dh,0ah
 db "",0dh,0ah
 db "        ɂ̃wb_Í邩Ȃݒ肵܂B",0dh,0ah
 db "        ftHg off łB",0dh,0ah
 db "",0dh,0ah
 db "      {N}",0dh,0ah
 db "",0dh,0ah
 db "        ̏ݒ肵܂B",0dh,0ah
 db "        ܂A̓p[^ƕт邽߂ɂgp܂B",0dh,0ah
 db "        l 0 n߂Kv܂B",0dh,0ah
 db "        ď̕gp܂B",0dh,0ah
 db "",0dh,0ah
 db "      b{C1}[s{S1}]:{C2}[s{S2}]",0dh,0ah
 db "",0dh,0ah
 db "        GR[_ C1 ̏o̓Xg[ S1 ƃGR[_ C2 ",0dh,0ah
 db "        ̓Xg[ S2 ѕt܂B",0dh,0ah
 db "        Xg[ԍw肳ȂȂ",0dh,0ah
 db "        0 ԍ̃Xg[gł傤B",0dh,0ah
 db "",0dh,0ah
 db "        ʏAGR[_͓̓Xg[",0dh,0ah
 db "        o̓Xg[ÂĂ܂B",0dh,0ah
 db "        7z GR[_͊̓͂Əo̓Xg[o܂B",0dh,0ah
 db "",0dh,0ah
 db "        Ⴆ΁ABCJ2 GR[_͈̓̓Xg[",0dh,0ah
 db "        l̏o̓Xg[Ă܂B",0dh,0ah
 db "",0dh,0ah
 db "      mt=[off | on]",0dh,0ah
 db "",0dh,0ah
 db "        }`Xbh[hݒ肵܂B",0dh,0ah
 db "        A}`vZbTVXe Pentium 4 ̃nCp[",0dh,0ah
 db "        XbfBOĂȂ΁A}`XbfBO",0dh,0ah
 db "        XCb` on ɂ鎖ňkx𑝉鎖o܂B",0dh,0ah
 db "        ̃IvV LZMA kɂp܂B",0dh,0ah
 db "",0dh,0ah
 db "      {N}={MethodID}[:param1][:param2] ... [:paramN]",0dh,0ah
 db "",0dh,0ah
 db "        k̐ݒ܂B",0dh,0ah
 db "        ̕gƂ\łB",0dh,0ah
 db "        ftHg LZMA łB",0dh,0ah
 db "",0dh,0ah
 db "        p[^̌`͈ȉ̂̈Ŗ΂Ȃ܂B",0dh,0ah
 db "",0dh,0ah
 db "        E{ParamName}={ParamValue}",0dh,0ah
 db "        E{ParamName}{ParamValue}",0dh,0ah
 db "          A{ParamValue}l{ParamName}ɐl܂܂ȂꍇB",0dh,0ah
 db "",0dh,0ah
 db "@  @  \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "        MethodID                                            ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "        LZMA    LZ ASYɊÂASYB           ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "        PPMd    Dmitry Shkarin  PPMdH ́B  ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "        BZip2   BWT ASYB                              ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "        Deflate LZ + HuffmanB                                  ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "        BCJ     32-bit x86 st@C`ׂ̈               ",0dh,0ah
 db "                (CALL, JUMP) ϊB                         ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "        BCJ2    32-bit x86 st@C`ׂ̈               ",0dh,0ah
 db "                (CALL, JUMP, JCC) ϊB(version 2)         ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "        Copy    kB                                        ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "",0dh,0ah
 db "        LZMA",0dh,0ah
 db "",0dh,0ah
 db "          LZMA ́ALempel-Ziv ASYɊÂASYłB",0dh,0ah
 db "          ͔̕ɉ𓀑xłB",0dh,0ah
 db "          (kxɔׁA 10 - 20% )",0dh,0ah
 db "          ̗vʂ͈kƉ𓀎ňقȂ܂B",0dh,0ah
 db "          (ڍׂ d={Size}[b|k|m] XCb`QƂĂ)",0dh,0ah
 db "",0dh,0ah
 db "    @  @\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "          p[^    W                              ",0dh,0ah
 db "          \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "          a=[0|1|2]       1 k[hݒB                ",0dh,0ah
 db "          \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "          d={Size}       20 bTCYݒB                b",0dh,0ah
 db "          [b|k|m]                                             ",0dh,0ah
 db "          \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "          mf={MF_ID}    bt4 }b`t@C_ݒB          ",0dh,0ah
 db "          \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "          fb=           b 32 bŒ肷郁̃oCgݒB  b",0dh,0ah
 db "          b{NumFastBytes}                                      ",0dh,0ah
 db "          \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "          lc={N}          3 Literal Context bits lݒ[0,8]",0dh,0ah
 db "          \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "          lp={N}          0 Literal Pos bits lݒ[0,4]    ",0dh,0ah
 db "          \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "          pb={N}          2 Pos Bits lݒ[0,4]            ",0dh,0ah
 db "          \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "",0dh,0ah
 db "          a=[0|1|2]",0dh,0ah
 db "",0dh,0ah
 db "            k[hݒ肵܂B",0dh,0ah
 db "            0 = xB1 = WB2 = kB",0dh,0ah
 db "            ftHg 1 łB",0dh,0ah
 db "",0dh,0ah
 db "          d={Size}[b|k|m]",0dh,0ah
 db "",0dh,0ah
 db "            LZMA ̎TCYݒ肵܂B",0dh,0ah
 db "            oCgLoCgKoCgݒ肵Ȃ΂Ȃ܂B",0dh,0ah
 db "            TCY̍ől 256MB = 2^28 oCgłB",0dh,0ah
 db "            LZMA ̃ftHgl͕W[h 20(1MB) A",0dh,0ah
 db "            ő僂[h (-mx)  23(8MB) łB",0dh,0ah
 db "             [b|k|m] 牽w肵Ȃ΁A",0dh,0ah
 db "            TCY 2^Size oCgŎZo܂B",0dh,0ah
 db "            LZMA ̎TCY N ňkꂽt@C",0dh,0ah
 db "            𓀂ۂɂ́A悻 N*2 ̃(RAM)KvłB",0dh,0ah
 db "",0dh,0ah
 db "          mf={MF_ID}",0dh,0ah
 db "",0dh,0ah
 db "            LZMA ̃}b`t@C_[ݒ肵܂B",0dh,0ah
 db "            ftHg̕@ bt4 łB",0dh,0ah
 db "            bt* nɂ@ pat* nɂ@",0dh,0ah
 db "            KvƂ郁͏ł݂܂B",0dh,0ah
 db "            ʏAbt* n͂ǂ pat* nłA",0dh,0ah
 db "            t@C^Cvł pat* n̕ꍇL܂B",0dh,0ah
 db "            hc* nASY͈k͈ł",0dh,0ah
 db "            x[h (a=0) Ƒgݍ킹ƔɍłB",0dh,0ah
 db '            Kvȃ͎TCY (L̕\̃p[^ "d") ',0dh,0ah
 db "            ˑ܂B",0dh,0ah
 db "",0dh,0ah
 db "    @    @\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "            MF_ID                                   ",0dh,0ah
 db "            \\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "            bt2   d*9.5 + 1MB   2 oCgnbV@̓񕪖؁B  b",0dh,0ah
 db "            \\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "            bt3   d*9.5 + 65MB  2,3(full) oCgnbV@  ",0dh,0ah
 db "                                񕪖؁B                      ",0dh,0ah
 db "            \\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "            bt4   d*9.5 + 6MB   2,3,4 oCgnbV@      ",0dh,0ah
 db "                                񕪖؁B                      ",0dh,0ah
 db "            \\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "            bt4b  d*9.5 + 34MB  2,3,4(big) oCgnbV@ ",0dh,0ah
 db "                                񕪖؁B                      ",0dh,0ah
 db "            \\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "            pat2r d*26 + 1MB    2 rbgm[h              ",0dh,0ah
 db "                                pgVA؂B          ",0dh,0ah
 db "            \\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "            pat2  d*38 + 1MB    2 rbgm[h̃pgVA؁B",0dh,0ah
 db "            \\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "            pat2h d*38 + 77MB   2 rbgm[h̃pgVA؁A",0dh,0ah
 db "                                2,3 oCgnbV@B        ",0dh,0ah
 db "            \\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "            pat3h d*62 + 85MB   3 rbgm[h̃pgVA؁A",0dh,0ah
 db "                                2,3 oCgnbV@B        ",0dh,0ah
 db "            \\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "            pat4h d*110 + 101MB 4 rbgm[h̃pgVA؁A",0dh,0ah
 db "                                2,3 oCgnbV@B        ",0dh,0ah
 db "            \\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "            hc3   d*5.5 + 1MB   2,3 oCgnbV@        ",0dh,0ah
 db "                                nbV`F[B            ",0dh,0ah
 db "            \\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "            hc4   d*5.5 + 6MB   2,3,4 oCgnbV@      ",0dh,0ah
 db "                                nbV`F[B            ",0dh,0ah
 db "            \\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "",0dh,0ah
 db "            : OS ̓VXepɂx̕KvƂ܂B",0dh,0ah
 db "                ׁ̈AŒ 32MB ͕c悤ɂĉB",0dh,0ah
 db "",0dh,0ah
 db "          fb={NumFastBytes}",0dh,0ah
 db "",0dh,0ah
 db "            LZMA ׂ̈ɗD悷郁̃oCgݒ肵܂B",0dh,0ah
 db "            oCg 5 - 255 ̊Ԃɐݒ肵ĂB",0dh,0ah
 db "            ftHgl͕W[h 32 ňk[h 64 łB",0dh,0ah
 db "            ʏA傫lݒ肷ƈk͎኱Ȃ",0dh,0ah
 db "            kx͒xȂ܂B",0dh,0ah
 db "",0dh,0ah
 db "          lc={N}",0dh,0ah
 db "",0dh,0ah
 db "            Literal context bits lݒ肵܂B",0dh,0ah
 db "            0  8 ͈̔͂ŃftHgl 3 łB",0dh,0ah
 db "            ɂAlc=4 ͑傫ȃt@Cׂ̈ɗv^܂B",0dh,0ah
 db "",0dh,0ah
 db "          lp={N}",0dh,0ah
 db "",0dh,0ah
 db "            Literal pos bits lݒ肵܂B",0dh,0ah
 db "            0  4 ͈̔͂ŃftHgl 0 łB",0dh,0ah
 db "            Ԃ 2Ovalue(lp=value ɂ)łꍇ",0dh,0ah
 db "            lpXCb`͎Iȃf[^̂߂ɈӐ}܂B",0dh,0ah
 db "            Ⴆ΁A32rbgi4oCgj̎Iȃf[^̂߂",0dh,0ah
 db "            lp=2 gƂł܂B",0dh,0ah
 db "            Alp XCb`ςȂ΁Alc=0 ݒ肷",0dh,0ah
 db "            ΂ΗǂȂ܂B",0dh,0ah
 db "",0dh,0ah
 db "          pb={N}",0dh,0ah
 db "",0dh,0ah
 db "            Pos bits lݒ肵܂B ",0dh,0ah
 db "            0  4 ͈̔͂ŃftHgl 2 łB",0dh,0ah
 db "            Ԃ 2Ovalue(lp=value ɂ)łꍇ",0dh,0ah
 db "            ppXCb`͎Iȃf[^̂߂ɈӐ}܂B",0dh,0ah
 db "",0dh,0ah
 db "        PPMd",0dh,0ah
 db "",0dh,0ah
 db "          PPMd  PPM x[XɂASYłB",0dh,0ah
 db "          ̃ASÝAق Dmitry Shkarin  PPMdH ",0dh,0ah
 db "          \[XɊÂĂ܂B",0dh,0ah
 db "          PPMd ͕̃eLXgt@CŔɍk񋟂܂B",0dh,0ah
 db "          kxƉ𓀑x͓łB",0dh,0ah
 db "          kƉ𓀂ŕKv郁łB",0dh,0ah
 db "",0dh,0ah
 db "    @    \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "          p[^        W                          ",0dh,0ah
 db "          \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "          mem={Size}[b|k|m]  24 gp郁ݒB      ",0dh,0ah
 db "          \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "          o={Size}            6 fނݒB            ",0dh,0ah
 db "          \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "",0dh,0ah
 db "          mem={Size}[b|k|m]",0dh,0ah
 db "",0dh,0ah
 db "            PPMd ׂ̈Ɏg郁̃TCYݒ肵܂B",0dh,0ah
 db "            oCgLoCgKoCgݒ肵Ȃ΂Ȃ܂B",0dh,0ah
 db "            ől 2GB=2^31 oCgŁAftHgl 24(16MB) łB",0dh,0ah
 db "             [b|k|m] 牽w肵Ȃ΁A",0dh,0ah
 db "            TCY 2^Size oCgŎZo܂B",0dh,0ah
 db "            PPMd ͈kƓʂ̃𓀎Ɏgp܂B",0dh,0ah
 db "",0dh,0ah
 db "          o={Size}",0dh,0ah
 db "",0dh,0ah
 db "            PPMd ׂ̈̃fނݒ肵܂B",0dh,0ah
 db "            Size  2 - 32 ̊Ԃɐݒ肵ĉB",0dh,0ah
 db "            ftHgl 6 łB",0dh,0ah
 db "",0dh,0ah
 db "        BCJ2",0dh,0ah
 db "",0dh,0ah
 db "          BCJ2  32-bit x86 s\t@Cׂ̈",0dh,0ah
 db "          Branch Ro[^łBiversion 2j",0dh,0ah
 db "          k̑i𑝑傳ׂ̊̕򖽗߂ϊ܂B",0dh,0ah
 db "",0dh,0ah
 db "          BCJ2 GR[_͈̓̓Xg[",0dh,0ah
 db "          l̏o̓Xg[Ă܂B",0dh,0ah
 db "",0dh,0ah
 db "          Es0: CXg[BXɈkKv܂B",0dh,0ah
 db "          Es1: ϊ CALL lׂ̈̃Xg[BXɈkKvłB",0dh,0ah
 db "          Es2: ϊ JUMP lׂ̈̃Xg[BXɈkKvłB",0dh,0ah
 db "          Es3: T[rXXg[BɈkĂ܂B",0dh,0ah
 db "",0dh,0ah
 db "           LZMA gꂽȂAXg[ s1  s2 ׂ̈",0dh,0ah
 db "          TCÝAXg[ s0 ׂ̈̎TCY",0dh,0ah
 db "          ƏȂł傤Bi512KBłقƂǂ̏ꍇ\ł)",0dh,0ah
 db "",0dh,0ah
 db "    :",0dh,0ah
 db "      a -tzip archive.zip *.jpg -m0",0dh,0ah
 db "",0dh,0ah
 db "        k *.jpg t@C archive.zip ɒǉ܂B",0dh,0ah
 db "",0dh,0ah
 db "      a -t7z archive.7z *.exe *.dll -m0=BCJ -m1=LZMA:d=21 -ms",0dh,0ah
 db "",0dh,0ah
 db "        BCJ ϊƎTCY 2MB  LZMA g",0dh,0ah
 db "        \bh[h archive.7z  *.exe  *.dll ǉ܂B",0dh,0ah
 db "",0dh,0ah
 db "      a -t7z archive.7z *.exe *.dll -m0=BCJ2 -m1=LZMA:d23 -m2=LZMA:d19",0dh,0ah
 db "        -m3=LZMA:d19 -mb0:1 -mb0s1:2 -mb0s2:3",0dh,0ah
 db "",0dh,0ah
 db "        BCJ2 ϊg archive.7z  *.exe  *.dll ",0dh,0ah
 db "        TCY 8MB  LZMA ƌѕt BCJ2 ",0dh,0ah
 db "        Co̓Xg[ (s0)  LZMA ƌѕt",0dh,0ah
 db "        BCJ2  s1,s2 o̓Xg[Œǉ܂B",0dh,0ah
 db "",0dh,0ah
 db "      a -t7z archive.7z *.txt -m0=PPMd",0dh,0ah
 db "",0dh,0ah
 db "        PPMd g *.txt t@C archive.7z ɒǉ܂B",0dh,0ah
 db "",0dh,0ah
 db "    ̃XCb`ƋɎgpłR}hB",0dh,0ah
 db "",0dh,0ah
 db "      a, d, u",0dh,0ah
 db "",0dh,0ah
 db "    Q",0dh,0ah
 db "",0dh,0ah
 db "      XCb`: -t",0dh,0ah
 db "",0dh,0ah
 db "  -o : o͐fBNg̐ݒ",0dh,0ah
 db "  PPPPPPPPPPPPPPP",0dh,0ah
 db "      t@C𓀂̃fBNgݒ肵܂B",0dh,0ah
 db "      ̃XCb`͉𓀃R}h̎gp܂B",0dh,0ah
 db "",0dh,0ah
 db "    \: -o{dir_path}",0dh,0ah
 db "",0dh,0ah
 db "      {dir_path}",0dh,0ah
 db "",0dh,0ah
 db "        o̓fBNg̃pXݒ肵܂B",0dh,0ah
 db "        Ō \ ŏIKv͂܂B",0dh,0ah
 db "",0dh,0ah
 db "    : x archive.zip -oc:\Doc",0dh,0ah
 db "",0dh,0ah
 db "      archive.zip ̑SẴt@C c:\Doc fBNgɉ𓀂܂B",0dh,0ah
 db "",0dh,0ah
 db "    ̃XCb`ƋɎgpłR}hB",0dh,0ah
 db "",0dh,0ah
 db "      e, x",0dh,0ah
 db "",0dh,0ah
 db "  -p : pX[h̐ݒ",0dh,0ah
 db "  PPPPPPPPPPP",0dh,0ah
 db "      pX[hw肵܂B",0dh,0ah
 db "",0dh,0ah
 db "    \: -p{password}",0dh,0ah
 db "",0dh,0ah
 db "      {password}",0dh,0ah
 db "",0dh,0ah
 db "        pX[hw肵܂B",0dh,0ah
 db "",0dh,0ah
 db "    : x archive.zip -psecret",0dh,0ah
 db "",0dh,0ah
 db '      archive.zip pX[h "secret" gđSĉ𓀂܂B',0dh,0ah
 db "",0dh,0ah
 db "    ̃XCb`ƋɎgpłR}hB",0dh,0ah
 db "",0dh,0ah
 db "      a , d, e, t, u, x",0dh,0ah
 db "",0dh,0ah
 db "",0dh,0ah
 db "  -r : TufBNg̍ċAI",0dh,0ah
 db "  PPPPPPPPPPPPPPPPP",0dh,0ah
 db "      ChJ[hƃt@C̈@w肵܂B",0dh,0ah
 db "",0dh,0ah
 db "    \: -r[- | 0]",0dh,0ah
 db "",0dh,0ah
 db "@@\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "    XCb`                                        ",0dh,0ah
 db "    \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "    -r@  @ċAIfBNgLɂ܂B      ",0dh,0ah
 db "            ̃IvV͏ɓ̃t@C𑀍삷  ",0dh,0ah
 db "            R}h̃ftHgݒłB              ",0dh,0ah
 db "            bR}hFe, l, t, x                        ",0dh,0ah
 db "    \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "    -r-     ċAIfBNg𖳌ɂ܂B      ",0dh,0ah
 db "            ̃IvV̓fBXÑt@C      ",0dh,0ah
 db "            삷R}h̃ftHgݒłB      ",0dh,0ah
 db "            bR}hFa, d, u                           ",0dh,0ah
 db "    \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "    -r0 @@ChJ[hɕtĂ                  ",0dh,0ah
 db "       @@ ċAIfBNgLɂ܂B      ",0dh,0ah
 db "    \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "",0dh,0ah
 db "    :",0dh,0ah
 db "      l archive.zip -r- *.doc",0dh,0ah
 db "",0dh,0ah
 db "        archive.zip ɓ̃[gfBNg",0dh,0ah
 db "        SĂ *.doc t@C̃Xg _szOutput ɏo͂܂B",0dh,0ah
 db "",0dh,0ah
 db "      a -tzip archive.zip -r src\*.cpp src\*.h",0dh,0ah
 db "",0dh,0ah
 db "        src fBNgƂ̃TufBNg̑SĂ",0dh,0ah
 db "        *.cpp  *.h t@C archive.zip ɒǉ܂B",0dh,0ah
 db "",0dh,0ah
 db "    ̃XCb`ƋɎgpłR}hB",0dh,0ah
 db "",0dh,0ah
 db "      a, d, e, l, t, u, x",0dh,0ah
 db "",0dh,0ah
 db "    Q",0dh,0ah
 db "",0dh,0ah
 db "      XCb`: -i, -x",0dh,0ah
 db "",0dh,0ah
 db "  -sfx : ȉ𓀏ɂ̍쐬",0dh,0ah
 db "  PPPPPPPPPPPPP",0dh,0ah
 db "",0dh,0ah
 db "      ȉ𓀏ɂ쐬܂B",0dh,0ah
 db "      SFX W[͖{ 7-zip ʓr肷KvL܂B",0dh,0ah
 db "      ȉ SFX W[͖̐{Ƃ̐̕ɂȂ܂B",0dh,0ah
 db "",0dh,0ah
 db "    \: -sfx[{SFX_Module}]",0dh,0ah
 db "",0dh,0ah
 db "      {SFX_Module}",0dh,0ah
 db "",0dh,0ah
 db "        ɂɒǉ SFX W[w肵܂B",0dh,0ah
 db "        W[ 7-zip.dll ƓfBNgɒuKvL܂B",0dh,0ah
 db "",0dh,0ah
 db "@  @  \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "        SFX_Module                                      ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "        7z.sfx    Windows o[WB                      ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "        7zC.sfx   kꂽ Windows o[WB           ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "        7zCon.sfx R\[o[WB                    ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "        7zS.sfx   CXg[ Windows o[WB       ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "        7zSD.sfx  CXg[ Windows o[WB       ",0dh,0ah
 db "                  (MSVCRT.dll gp)                       ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "        wȂ  DLL ɓꂽgpB                ",0dh,0ah
 db "                  7zSD.sfx ɉǂkB               ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "",0dh,0ah
 db "        7zC.sfx ȊO SFX W[͈kĂ܂B",0dh,0ah
 db "        ̃W[kׂ UPX vO",0dh,0ah
 db "        (http://upx.sourceforge.net) gƂo܂B",0dh,0ah
 db "        UPX vO SFX W[k邱Ƃ",0dh,0ah
 db "        IWĩTCY 40-50% TCY炷Ƃo܂B",0dh,0ah
 db "",0dh,0ah
 db "    CXg[p SFX W[",0dh,0ah
 db "",0dh,0ah
 db "      CXg[p SFX W[ (7zWinS.sfx and 7zWinSR.sfx) ",0dh,0ah
 db "      CXg[vO쐬邱Ƃ\łB",0dh,0ah
 db "      ̃W[ temp tH_ɏɂ𓀌A",0dh,0ah
 db "      w肵vOsAvOI",0dh,0ah
 db "      ꎞt@C폜܂B",0dh,0ah
 db "",0dh,0ah
 db "      CXg[p̎ȉ𓀏ɂ͈ȉ 3 ̃t@C",0dh,0ah
 db "      qčȂ΂Ȃ܂B",0dh,0ah
 db "      : SFX_Module, Installer_Config, 7z_Archive",0dh,0ah
 db "      Installer_Config ̓IvVt@CłB",0dh,0ah
 db "",0dh,0ah
 db "      CXg[p̎ȉ𓀏ɂ쐬ׂɁA",0dh,0ah
 db "      ȉ̃R}hgp邱Ƃo܂B",0dh,0ah
 db "",0dh,0ah
 db "        copy /b 7zS.sfx + config.txt + archive.7z archive.exe",0dh,0ah
 db "",0dh,0ah
 db "       7z ɂɊ܂܂OɃCXg[t@CkȂ΁A",0dh,0ah
 db "      ŏ̃TCYŃCXg[pbP[W̏ɂo܂B",0dh,0ah
 db "",0dh,0ah
 db "      CXg[W[ -y XCb`w肷",0dh,0ah
 db "      𓀎ɖ₢킹ȂȂ܂B",0dh,0ah
 db "",0dh,0ah
 db "    CXg[ݒt@C`",0dh,0ah
 db "",0dh,0ah
 db "      ݒt@C̓CXg[ׂ̈̃R}h܂݂܂B",0dh,0ah
 db "      t@C͕ ;!@Install@!UTF-8! Ŏn܂ ",0dh,0ah
 db "      ;!@InstallEnd@! ŏI܂B",0dh,0ah
 db "      t@C UTF-8 R[hŏȂ΂Ȃ܂B",0dh,0ah
 db "",0dh,0ah
 db "      t@C̓yA̕܂ł܂B",0dh,0ah
 db '      ID_String="Value"',0dh,0ah
 db "      ",0dh,0ah
 db "@  @\\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "      ID_String                                           ",0dh,0ah
 db "      \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "      Title       bZ[W̃^CgB                      ",0dh,0ah
 db "      \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "      BeginPrompt Jnvvg̃bZ[WB                ",0dh,0ah
 db "      \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "      RunProgram  sR}hB                          ",0dh,0ah
 db "                   %%T ́At@C𓀂ꂽꎞI ",0dh,0ah
 db "                  tH_̃pXƒu܂B          ",0dh,0ah
 db "      \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "",0dh,0ah
 db "      ǂ Value ȗ邱Ƃł܂B",0dh,0ah
 db "",0dh,0ah
 db "    ݒt@C̗",0dh,0ah
 db "",0dh,0ah
 db "        ;!@Install@!UTF-8!",0dh,0ah
 db '        Title="7-Zip 2.30"',0dh,0ah
 db '        BeginPrompt="Do you want to install the 7-Zip 2.30?"',0dh,0ah
 db '        RunProgram="Setup.exe /T:%%T"',0dh,0ah
 db "        ;!@InstallEnd@!",0dh,0ah
 db "",0dh,0ah
 db "      vO BeginPrompt ̃bZ[W\",0dh,0ah
 db "      ꂩ RunProgram ̃R}hs܂B",0dh,0ah
 db "      ̒PȃCXg[ .inf t@CɊÂA",0dh,0ah
 db "      advpack.dll gp܂B",0dh,0ah
 db "",0dh,0ah
 db "    ꂽ SFX W[",0dh,0ah
 db "",0dh,0ah
 db "      ɍ쐬Ƀ^Cg(Title)AJnbZ[W(BeginPrompt)A",0dh,0ah
 db "      sR}h(RunProgram)𕷂ė܂B",0dh,0ah
 db "      sR}hȗƁA𓀎ɉ𓀐wo悤ɂȂA",0dh,0ah
 db "      sR}hw肷ƃe|fBNgɈꎞ𓀌",0dh,0ah
 db "      w肳ꂽt@CsIɈꎞt@C͍폜܂B",0dh,0ah
 db "",0dh,0ah
 db "    ",0dh,0ah
 db "      a -sfx a.exe *.txt",0dh,0ah
 db "",0dh,0ah
 db "        ꂽ SFX W[g*.txt t@C",0dh,0ah
 db "        ȉ𓀏 a.exe ɒǉ܂B",0dh,0ah
 db "",0dh,0ah
 db "      a -sfx7zWin.sfx a.exe * -r",0dh,0ah
 db "",0dh,0ah
 db "        Windows o[W 7z.sfx SFX W[g",0dh,0ah
 db "        SẴt@C a.exe ɒǉ܂B",0dh,0ah
 db "",0dh,0ah
 db "    ̃XCb`ƋɎgpłR}hB",0dh,0ah
 db "",0dh,0ah
 db "      a, d, u",0dh,0ah
 db "",0dh,0ah
 db "  -t : ɂ̌`ݒ",0dh,0ah
 db "  PPPPPPPPPPP",0dh,0ah
 db "      ɂ̌`ݒ肵܂B",0dh,0ah
 db "",0dh,0ah
 db "    \: -t{archive_type}",0dh,0ah
 db "",0dh,0ah
 db "      {archive_type} ",0dh,0ah
 db "",0dh,0ah
 db "        ɂ̌`w肵܂B",0dh,0ah
 db "        `͈ȉ̕wł܂B",0dh,0ah
 db "        : 7z, zip",0dh,0ah
 db "        ftHg 7z `łB",0dh,0ah
 db "",0dh,0ah
 db "    : a -tzip archive.zip *.txt",0dh,0ah
 db "",0dh,0ah
 db "      JgfBNg̑SĂ *.txt t@C",0dh,0ah
 db "      zip ` archive.zip ɒǉ܂B",0dh,0ah
 db "",0dh,0ah
 db "    ̃XCb`ƋɎgpłR}hB",0dh,0ah
 db "",0dh,0ah
 db "      a, u",0dh,0ah
 db "",0dh,0ah
 db "  -u : XVIvV",0dh,0ah
 db "  PPPPPPPPPP",0dh,0ah
 db "      ǂ̂悤ɏɂ̃t@CXV邩Ay",0dh,0ah
 db "      ǂ̂悤ɏɂ쐬邩ݒ肵܂B",0dh,0ah
 db "",0dh,0ah
 db "    \: -u[-]<action_set>[!{new_archive_name}]",0dh,0ah
 db "",0dh,0ah
 db "            <action_set>   ::= <state_action>...",0dh,0ah
 db "            <state_action> ::= <state><action>",0dh,0ah
 db "            <state>        ::= p | q | r | x | y | z | w",0dh,0ah
 db "            <action>       ::= 0 | 1 | 2 | 3",0dh,0ah
 db "",0dh,0ah
 db "    p[^",0dh,0ah
 db "",0dh,0ah
 db "      nCt (-)",0dh,0ah
 db "",0dh,0ah
 db "        ̏ɂ̍XVoȂ܂B",0dh,0ah
 db "",0dh,0ah
 db "        ̏ɂƂ̓R}hC base_archive_name ̎łB",0dh,0ah
 db "        ڍׂ́u1. R}hC̗lvQlɂĉB",0dh,0ah
 db "",0dh,0ah
 db "      {new_archive_name}",0dh,0ah
 db "",0dh,0ah
 db "        쐬Vɂ̃pXݒ肵܂B",0dh,0ah
 db "        ̃XCb`̑SẴIvV͐VɂQƂ܂B",0dh,0ah
 db "",0dh,0ah
 db "        蓖ĂȂ΁ÃXCb`̑SẴIvV",0dh,0ah
 db "        R}ȟ̏ɂQƂ܂B",0dh,0ah
 db "",0dh,0ah
 db "      <state>",0dh,0ah
 db "",0dh,0ah
 db "        ̏ꂽt@C̏Ԃw肵܂B",0dh,0ah
 db "",0dh,0ah
 db "        <state> ::= p | q | r | x | y | z | w",0dh,0ah
 db "",0dh,0ah
 db "        X̓Ǝȃt@CɊւāAZ̈قȂԂ܂B",0dh,0ah
 db "",0dh,0ah
 db "@@    \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "        <state>                     fBXNbɓ  ",0dh,0ah
 db "                                        ̃t@Cbt@C  ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "                t@C͏ɓɑ            ݂邪",0dh,0ah
 db "           p    邪ChJ[hƄ          vȂ",0dh,0ah
 db "                vȂB                                ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "                t@C͏ɓɑ                      ",0dh,0ah
 db "           q    邪fBXNɂ    ݂Ȃ݂  ",0dh,0ah
 db "                ݂ȂB                                ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "                t@C͏ɓɑ                      ",0dh,0ah
 db "           r    ȂfBXNɂ  ݂  ݂Ȃ",0dh,0ah
 db "                ݂B                                  ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "                ɓ̃t@C                          ",0dh,0ah
 db "           x    fBXÑt@C脠Â      V    ",0dh,0ah
 db "                VB                                    ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "                ɓ̃t@C                          ",0dh,0ah
 db "           y    fBXÑt@C脠V    Â      ",0dh,0ah
 db "                ÂB                                      ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "                ɓ̃t@C                          ",0dh,0ah
 db "           z    fBXÑt@C              ",0dh,0ah
 db "                B                                      ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "                ǂ̃t@CV                      ",0dh,0ah
 db "           w    ołȂB( XVH        H        ",0dh,0ah
 db "                ͓TCYႤ )                    ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "",0dh,0ah
 db "      <action>",0dh,0ah
 db "",0dh,0ah
 db "        <appropriate> ɓK؂ȓݒ肵܂B",0dh,0ah
 db "",0dh,0ah
 db "        <action> ::= 0 | 1 | 2 | 3",0dh,0ah
 db "",0dh,0ah
 db "        X̏ԂɊւāAO̈قȂ铮삩Ił܂B",0dh,0ah
 db "",0dh,0ah
 db "@  @  \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "        <action>                                            ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "           0    t@C𖳎B(̃t@Cׂ̈             ",0dh,0ah
 db "                VɓɃACe쐬܂)           ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "           1    t@CRs[B                              ",0dh,0ah
 db "                (ÂɂVɂփRs[܂)          ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "           2    kB                                          ",0dh,0ah
 db "                (VɂɃfBXNt@Ck܂)  ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "           3    ACe쐬B(𓀒Ƀt@C           ",0dh,0ah
 db "                fBNg폜ACej                ",0dh,0ah
 db "                ̋@\ 7z `݂̂ŃT|[g܂B      ",0dh,0ah
 db "        \\\\\\\\\\\\\\\\\\\\\\\\\\\\",0dh,0ah
 db "",0dh,0ah
 db "    ",0dh,0ah
 db "",0dh,0ah
 db "      SĂ̍XVR}h (a, d, u ) ͂̏蓖Ă܂B",0dh,0ah
 db "",0dh,0ah
 db "      ȉ̕\͍XVR}hƓ̑gݍ킹łB",0dh,0ah
 db "",0dh,0ah
 db "@  @\\\\\\\\\\\\\\\\",0dh,0ah
 db "      R}h / <state>b pb qb rb xb yb zb w",0dh,0ah
 db "      \\\\\\\\\\\\\\\\",0dh,0ah
 db "              d         b 1b 0b 0b 0b 0b 0b 0",0dh,0ah
 db "      \\\\\\\\\\\\\\\\",0dh,0ah
 db "              a         b 1b 1b 2b 2b 2b 2b 2",0dh,0ah
 db "      \\\\\\\\\\\\\\\\",0dh,0ah
 db "              u         b 1b 1b 2b 1b 2b 1b 2",0dh,0ah
 db "      \\\\\\\\\\\\\\\\",0dh,0ah
 db "",0dh,0ah
 db "       !{new_archive_name} IvVw肵ȂȂ",0dh,0ah
 db "      SẴIvV̓C (R}hCŃR}ȟ",0dh,0ah
 db "      蓖Ăꂽ) QƂ܂B",0dh,0ah
 db "       !{new_archive_name} IvVw肵Ȃ",0dh,0ah
 db "      7-zip32.dll w肳ꂽOɂĐVɂ쐬A",0dh,0ah
 db "      SẴIvV͂̐VɂQƂ܂B",0dh,0ah
 db "",0dh,0ah
 db "      XVXCb`͕wł܂B",0dh,0ah
 db "",0dh,0ah
 db "      7-zip32.dll ͈x̑ŉłVɂ쐬ł܂B",0dh,0ah
 db "      ftHgł́AX̐Vɂ̓̐ݒ́A",0dh,0ah
 db "      CR}hŐݒ肳ꂽ삪蓖Ă܂B",0dh,0ah
 db "",0dh,0ah
 db "      R}hɂ͐ݒł铮삪OޗL܂B",0dh,0ah
 db "      : a, d, u",0dh,0ah
 db "      ǂ <state_action> gݍ킹ł܂B",0dh,0ah
 db "",0dh,0ah
 db "    : u c:\1\exist.7z -u- -up0q3x2z0!c:\1\update.7z * -r",0dh,0ah
 db "",0dh,0ah
 db "      V update.7z 쐬ȀɂɃJgfBNg",0dh,0ah
 db "      exist.7z ɓ̃t@CƈقȂSẴt@C݂܂B",0dh,0ah
 db "      exist.7z ɂ͕ύX܂B",0dh,0ah
 db "",0dh,0ah
 db "    ̃XCb`ƋɎgpłR}hB",0dh,0ah
 db "",0dh,0ah
 db "      a, d, u",0dh,0ah
 db "",0dh,0ah
 db "  -w : ƃfBNg̐ݒ",0dh,0ah
 db "  PPPPPPPPPPPPPP",0dh,0ah
 db "      ꎞIȊ{ɂׂ̈̍ƃfBNgݒ肵܂B",0dh,0ah
 db "      7-zip32.dll ̓ftHg AV{ɂÂ{ɂ",0dh,0ah
 db "      fBNgɍ쐬܂B",0dh,0ah
 db "      ̃XCb`w肷邱ƂŁAꎞIȊ{Ƀt@C",0dh,0ah
 db "      쐬ƃfBNg̏ꏊݒł܂B",0dh,0ah
 db "      ꎞIȊ{ɂ쐬ꂽ͌̏ɂɏ㏑",0dh,0ah
 db "      ꎞt@C͍폜܂B",0dh,0ah
 db "",0dh,0ah
 db "    \: -w[{dir_path}]",0dh,0ah
 db "",0dh,0ah
 db "      {dir_path}",0dh,0ah
 db "",0dh,0ah
 db "        ړĨfBNg̃pXw肵܂B",0dh,0ah
 db "        pX \ ŏIKv͂܂B",0dh,0ah
 db "",0dh,0ah
 db "         <dir_path> 蓖ĂȂ΁A7-zip32.dll ",0dh,0ah
 db "        Windows  temp fBNggp܂B",0dh,0ah
 db "",0dh,0ah
 db "    : a -tzip archive.zip *.cpp -wc:\temp",0dh,0ah
 db "",0dh,0ah
 db "      *.cpp t@C archive.zip ɒǉB",0dh,0ah
 db "      ꎞIȏɂ c:\temp ɍ쐬܂B",0dh,0ah
 db "",0dh,0ah
 db "    ̃XCb`ƋɎgpłR}hB",0dh,0ah
 db "",0dh,0ah
 db "      a, d, u",0dh,0ah
 db "",0dh,0ah
 db "  -x : t@CO",0dh,0ah
 db "  PPPPPPPPPP",0dh,0ah
 db "      삩珜Ot@CyуChJ[hw肵܂B",0dh,0ah
 db "      ̏OXCb`T|[g܂B",0dh,0ah
 db "",0dh,0ah
 db "    \: -x[<recurse_type>]<file_ref>",0dh,0ah
 db "",0dh,0ah
 db "            <recurse_type> ::= r[- | 0]",0dh,0ah
 db "            <file_ref>     ::= @{listfile} | !{wildcard}",0dh,0ah
 db "",0dh,0ah
 db "      IvVp[^̏ڍׂ -i XCb`QƂĂB",0dh,0ah
 db "",0dh,0ah
 db "    : a -tzip archive.zip *.txt -x!temp.*",0dh,0ah
 db "",0dh,0ah
 db "      archive.zip  temp.* SĂ *.txt t@Cǉ܂B",0dh,0ah
 db "",0dh,0ah
 db "  -y : SĂ̎ yes ",0dh,0ah
 db "  PPPPPPPPPPPPPP",0dh,0ah
 db "      7-zip32.dll sɃ[Uւ̎̊荞݂}܂B",0dh,0ah
 db "      ̃XCb`gp邱Ƃ e, x R}hł̏㏑mF",0dh,0ah
 db "      }邱Ƃo܂B",0dh,0ah
 db "",0dh,0ah
 db "    \: x src.zip -y",0dh,0ah
 db "",0dh,0ah
 db "      src.zip SẴt@C𓀂܂B",0dh,0ah
 db "      SĂ̏㏑mF͗}fBXÑt@C",0dh,0ah
 db "      ɓƓt@Ĉ̂͏㏑܂B",0dh,0ah
 db "",0dh,0ah
 db "    ̃XCb`ƋɎgpłR}hB",0dh,0ah
 db "",0dh,0ah
 db "      e, x",0dh,0ah
 db "",0dh,0ah
 db "    Q",0dh,0ah
 db "",0dh,0ah
 db "      XCb`: -ao",0dh,0ah
 db "",0dh,0ah
 db 0
	align	16
buf_ptr	dd	buf
cline_buf
	db	'-bd ',0
	align	16
	resb	CLINE_BUF_SIZE-5
	align	16
out_buf	resb	OUT_BUF_SIZE+1
	align	16
buf	resb	BUF_SIZE
